#include "ibm.h"
#include "aa.h"

#include "resource.h"

#include <stdio.h>

EXPORT UBYTE sx[2], sy[2];

IMPORT HWND  ControlsWindowPtr,
             MainWindowPtr,
			 MonitorWindowPtr;
IMPORT int   machine,
             monitortype;
IMPORT UBYTE oldkeys[KEYS];
IMPORT ULONG frames;
IMPORT int   rast;
IMPORT UBYTE psu;
IMPORT UBYTE memory[32768],
             oldstart,
			 olda,
			 oldb;
IMPORT ULONG elapsed,
             region;
IMPORT SLONG cycles;

MODULE UWORD monitorras[8],
             monitoriar,
             // PSGs
             monitorPITCHA[2],
             monitorPITCHB[2],
             monitorPITCHC[2],
             monitorPERIOD[2];
MODULE UBYTE monitorr[7],
             monitorpsu,
             monitorpsl,
             // UVI chip...
             monitorCONSOLE,
             monitorPITCH,
             monitorVOLUME,
             monitorRESOLUTION,
             monitorBGCOLLIDE,
             monitorBGCOLOUR,
             monitorVSCROLL,
             monitorCHARLINE,
             monitorSPRITECOLLIDE,
             monitorSPRITES01CTRL,
             monitorSPRITES23CTRL,
             monitorSPRITE0X,
             monitorSPRITE0Y,
             monitorSPRITE1X,
             monitorSPRITE1Y,
             monitorSPRITE2X,
             monitorSPRITE2Y,
             monitorSPRITE3X,
             monitorSPRITE3Y,
             monitorP1PADDLE,
             monitorP1LEFTKEYS,
             monitorP1MIDDLEKEYS,
             monitorP1RIGHTKEYS,
             monitorP1PALLADIUM,
             monitorP2PADDLE,
             monitorP2LEFTKEYS,
             monitorP2MIDDLEKEYS,
             monitorP2RIGHTKEYS,
             monitorP2PALLADIUM,
             // PVI...
             monitorNOISE,
             monitorSIZES,
             monitorSCORECTRL,
             monitorSCORELT,
             monitorSCORERT,
             monitorSPR01COLOURS,
             monitorSPR23COLOURS,
             monitorSPRITE0X2,
             monitorSPRITE0Y2,
             monitorSPRITE1X2,
             monitorSPRITE1Y2,
             monitorSPRITE2X2,
             monitorSPRITE2Y2,
             monitorSPRITE3X2,
             monitorSPRITE3Y2,
             // UVI RAM...
             monitor18D0[32],
             monitor18F8[4],
             monitor1AD0[48],
             // PVI RAM...
             monitor1F0E[2],
             monitor1F1E[2],
             monitor1F4E[32],
             monitor1FAD,
             // PSGs
             monitorPITCHD[2],
             monitorENABLE[2],
             monitorAMPLITUDEA[2],
             monitorAMPLITUDEB[2],
             monitorAMPLITUDEC[2],
             monitorSHAPE[2],
             monitorPORTA[2],
             monitorPORTB[2];
MODULE ULONG // XVI...
             monitorelapsed,
             monitorframes;
MODULE int   monitorrast;

IMPORT char  reg[2 + 1],
             mn[80 + 1];
IMPORT UBYTE opcode,
             rr,
             table_sz[256];
IMPORT UBYTE psl,
             r[7]; // register is a reserved word
IMPORT UWORD iar,
             page, // page select register
             ras[8];
IMPORT TEXT  ccstring[4][2 + 1],
             timestring[11 + 1];
IMPORT int   controlstype;

MODULE HWND  // CPU chip...
             RGad[7],
             CCPtr,
             SensePtr,
             FlagPtr,
             InterruptPtr,
             IDCPtr,
             RSPtr,
             WCPtr,
             OVFPtr,
             COMPtr,
             CPtr,
             RASGad[8],
             SPPtr,
             IARPtr,
             ClockPtr,
             FramePtr,
             RastPtr,
             TimePtr,
             // UVI chip...
             CONSOLEPtr,
             PITCHPtr,
             VOLUMEPtr,
             RESOLUTIONPtr,
             BGCOLOURPtr,
             VSCROLLPtr,
             CHARLINEPtr,
             BGCOLLIDEPtr,
             SPRITECOLLIDEPtr,
             SPRITES01CTRLPtr,
             SPRITES23CTRLPtr,
             SPRITE0XYPtr,
             SPRITE1XYPtr,
             SPRITE2XYPtr,
             SPRITE3XYPtr,
             P1PADDLEPtr,
             P1LEFTKEYSPtr,
             P1MIDDLEKEYSPtr,
             P1RIGHTKEYSPtr,
             P1PALLADIUMPtr,
             P2PADDLEPtr,
             P2LEFTKEYSPtr,
             P2MIDDLEKEYSPtr,
             P2RIGHTKEYSPtr,
             P2PALLADIUMPtr,
             // PVI chip...
             NOISEPtr,
             SCORECTRLPtr,
             SCORELTPtr,
             SCORERTPtr,
             SIZESPtr,
             SPR01COLOURSPtr,
             SPR23COLOURSPtr,
             SPRITE0XY2Ptr,
             SPRITE1XY2Ptr,
             SPRITE2XY2Ptr,
             SPRITE3XY2Ptr,
             // UVI RAM...
             Addr18D0Gad[32],
             Addr18F8Gad[4],
             Addr1AD0Gad[48],
             // PVI RAM...
             Addr1F0EGad[2],
             Addr1F1EGad[2],
             Addr1F4EGad[32],
             Addr1FADGad,
             // PSGs
             PITCHAGad[2],
             PITCHBGad[2],
             PITCHCGad[2],
             PITCHDGad[2],
             AMPLITUDEAGad[2],
             AMPLITUDEBGad[2],
             AMPLITUDECGad[2],
             ENABLEGad[2],
             PERIODGad[2],
             SHAPEGad[2],
             PORTAGad[2],
             PORTBGad[2];

EXPORT void initmonitor(void)
{   int i;

    // CPU chip...

    // assert(MonitorWindowPtr);

    RGad[0]      = GetDlgItem(MonitorWindowPtr, ID_R0);
    RGad[1]      = GetDlgItem(MonitorWindowPtr, ID_R1);
    RGad[2]      = GetDlgItem(MonitorWindowPtr, ID_R2);
    RGad[3]      = GetDlgItem(MonitorWindowPtr, ID_R3);
    RGad[4]      = GetDlgItem(MonitorWindowPtr, ID_R4);
    RGad[5]      = GetDlgItem(MonitorWindowPtr, ID_R5);
    RGad[6]      = GetDlgItem(MonitorWindowPtr, ID_R6);
    CCPtr        = GetDlgItem(MonitorWindowPtr, ID_CC);
    SensePtr     = GetDlgItem(MonitorWindowPtr, ID_SENSE);
    FlagPtr      = GetDlgItem(MonitorWindowPtr, ID_FLAG);
    InterruptPtr = GetDlgItem(MonitorWindowPtr, ID_INTERRUPT);
    IDCPtr       = GetDlgItem(MonitorWindowPtr, ID_IDC);
    RSPtr        = GetDlgItem(MonitorWindowPtr, ID_RS);
    WCPtr        = GetDlgItem(MonitorWindowPtr, ID_WC);
    OVFPtr       = GetDlgItem(MonitorWindowPtr, ID_OVF);
    COMPtr       = GetDlgItem(MonitorWindowPtr, ID_COM);
    CPtr         = GetDlgItem(MonitorWindowPtr, ID_C);
    SPPtr     = GetDlgItem(MonitorWindowPtr, ID_SP);
    RASGad[0] = GetDlgItem(MonitorWindowPtr, ID_RAS0);
    RASGad[1] = GetDlgItem(MonitorWindowPtr, ID_RAS1);
    RASGad[2] = GetDlgItem(MonitorWindowPtr, ID_RAS2);
    RASGad[3] = GetDlgItem(MonitorWindowPtr, ID_RAS3);
    RASGad[4] = GetDlgItem(MonitorWindowPtr, ID_RAS4);
    RASGad[5] = GetDlgItem(MonitorWindowPtr, ID_RAS5);
    RASGad[6] = GetDlgItem(MonitorWindowPtr, ID_RAS6);
    RASGad[7] = GetDlgItem(MonitorWindowPtr, ID_RAS7);
    IARPtr    = GetDlgItem(MonitorWindowPtr, ID_IAR);

    // shared CPU/UVI/PVI

    FramePtr         = GetDlgItem(MonitorWindowPtr, ID_FRAME);
    ClockPtr         = GetDlgItem(MonitorWindowPtr, ID_CLOCK);
    RastPtr          = GetDlgItem(MonitorWindowPtr, ID_RASTER);
    TimePtr          = GetDlgItem(MonitorWindowPtr, ID_TIME);

    CONSOLEPtr       = GetDlgItem(MonitorWindowPtr, ID_CONSOLE);
    PITCHPtr         = GetDlgItem(MonitorWindowPtr, ID_PITCH);
    BGCOLOURPtr      = GetDlgItem(MonitorWindowPtr, ID_BGCOLOUR);
    BGCOLLIDEPtr     = GetDlgItem(MonitorWindowPtr, ID_BGCOLLIDE);
    SPRITECOLLIDEPtr = GetDlgItem(MonitorWindowPtr, ID_SPRITECOLLIDE);
    P1PADDLEPtr      = GetDlgItem(MonitorWindowPtr, ID_P1PADDLE);
    P1LEFTKEYSPtr    = GetDlgItem(MonitorWindowPtr, ID_P1LEFTKEYS);
    P1MIDDLEKEYSPtr  = GetDlgItem(MonitorWindowPtr, ID_P1MIDDLEKEYS);
    P1RIGHTKEYSPtr   = GetDlgItem(MonitorWindowPtr, ID_P1RIGHTKEYS);
    P2PADDLEPtr      = GetDlgItem(MonitorWindowPtr, ID_P2PADDLE);
    P2LEFTKEYSPtr    = GetDlgItem(MonitorWindowPtr, ID_P2LEFTKEYS);
    P2MIDDLEKEYSPtr  = GetDlgItem(MonitorWindowPtr, ID_P2MIDDLEKEYS);
    P2RIGHTKEYSPtr   = GetDlgItem(MonitorWindowPtr, ID_P2RIGHTKEYS);
    SPRITE0XYPtr     = GetDlgItem(MonitorWindowPtr, ID_SPRITE0XY);
    SPRITE1XYPtr     = GetDlgItem(MonitorWindowPtr, ID_SPRITE1XY);
    SPRITE2XYPtr     = GetDlgItem(MonitorWindowPtr, ID_SPRITE2XY);
    SPRITE3XYPtr     = GetDlgItem(MonitorWindowPtr, ID_SPRITE3XY);

    if (machine == ARCADIA)
    {   // UVI chip...

        VOLUMEPtr        = GetDlgItem(MonitorWindowPtr, ID_VOLUME);
        RESOLUTIONPtr    = GetDlgItem(MonitorWindowPtr, ID_RESOLUTION);
        VSCROLLPtr       = GetDlgItem(MonitorWindowPtr, ID_VSCROLL);
        CHARLINEPtr      = GetDlgItem(MonitorWindowPtr, ID_CHARLINE);
        SPRITES01CTRLPtr = GetDlgItem(MonitorWindowPtr, ID_SPRITES01CTRL);
        SPRITES23CTRLPtr = GetDlgItem(MonitorWindowPtr, ID_SPRITES23CTRL);
        SPRITE0XYPtr     = GetDlgItem(MonitorWindowPtr, ID_SPRITE0XY);
        SPRITE1XYPtr     = GetDlgItem(MonitorWindowPtr, ID_SPRITE1XY);
        SPRITE2XYPtr     = GetDlgItem(MonitorWindowPtr, ID_SPRITE2XY);
        SPRITE3XYPtr     = GetDlgItem(MonitorWindowPtr, ID_SPRITE3XY);
        P1PALLADIUMPtr   = GetDlgItem(MonitorWindowPtr, ID_P1PALLADIUM);
        P2PALLADIUMPtr   = GetDlgItem(MonitorWindowPtr, ID_P2PALLADIUM);

        // UVI RAM...

        Addr18D0Gad[0]   = GetDlgItem(MonitorWindowPtr, ID_18D0);
        Addr18D0Gad[1]   = GetDlgItem(MonitorWindowPtr, ID_18D1);
        Addr18D0Gad[2]   = GetDlgItem(MonitorWindowPtr, ID_18D2);
        Addr18D0Gad[3]   = GetDlgItem(MonitorWindowPtr, ID_18D3);
        Addr18D0Gad[4]   = GetDlgItem(MonitorWindowPtr, ID_18D4);
        Addr18D0Gad[5]   = GetDlgItem(MonitorWindowPtr, ID_18D5);
        Addr18D0Gad[6]   = GetDlgItem(MonitorWindowPtr, ID_18D6);
        Addr18D0Gad[7]   = GetDlgItem(MonitorWindowPtr, ID_18D7);
        Addr18D0Gad[8]   = GetDlgItem(MonitorWindowPtr, ID_18D8);
        Addr18D0Gad[9]   = GetDlgItem(MonitorWindowPtr, ID_18D9);
        Addr18D0Gad[10]  = GetDlgItem(MonitorWindowPtr, ID_18DA);
        Addr18D0Gad[11]  = GetDlgItem(MonitorWindowPtr, ID_18DB);
        Addr18D0Gad[12]  = GetDlgItem(MonitorWindowPtr, ID_18DC);
        Addr18D0Gad[13]  = GetDlgItem(MonitorWindowPtr, ID_18DD);
        Addr18D0Gad[14]  = GetDlgItem(MonitorWindowPtr, ID_18DE);
        Addr18D0Gad[15]  = GetDlgItem(MonitorWindowPtr, ID_18DF);
        Addr18D0Gad[16]  = GetDlgItem(MonitorWindowPtr, ID_18E0);
        Addr18D0Gad[17]  = GetDlgItem(MonitorWindowPtr, ID_18E1);
        Addr18D0Gad[18]  = GetDlgItem(MonitorWindowPtr, ID_18E2);
        Addr18D0Gad[19]  = GetDlgItem(MonitorWindowPtr, ID_18E3);
        Addr18D0Gad[20]  = GetDlgItem(MonitorWindowPtr, ID_18E4);
        Addr18D0Gad[21]  = GetDlgItem(MonitorWindowPtr, ID_18E5);
        Addr18D0Gad[22]  = GetDlgItem(MonitorWindowPtr, ID_18E6);
        Addr18D0Gad[23]  = GetDlgItem(MonitorWindowPtr, ID_18E7);
        Addr18D0Gad[24]  = GetDlgItem(MonitorWindowPtr, ID_18E8);
        Addr18D0Gad[25]  = GetDlgItem(MonitorWindowPtr, ID_18E9);
        Addr18D0Gad[26]  = GetDlgItem(MonitorWindowPtr, ID_18EA);
        Addr18D0Gad[27]  = GetDlgItem(MonitorWindowPtr, ID_18EB);
        Addr18D0Gad[28]  = GetDlgItem(MonitorWindowPtr, ID_18EC);
        Addr18D0Gad[29]  = GetDlgItem(MonitorWindowPtr, ID_18ED);
        Addr18D0Gad[30]  = GetDlgItem(MonitorWindowPtr, ID_18EE);
        Addr18D0Gad[31]  = GetDlgItem(MonitorWindowPtr, ID_18EF);
        Addr18F8Gad[0]   = GetDlgItem(MonitorWindowPtr, ID_18F8);
        Addr18F8Gad[1]   = GetDlgItem(MonitorWindowPtr, ID_18F9);
        Addr18F8Gad[2]   = GetDlgItem(MonitorWindowPtr, ID_18FA);
        Addr18F8Gad[3]   = GetDlgItem(MonitorWindowPtr, ID_18FB);
        Addr1AD0Gad[0]   = GetDlgItem(MonitorWindowPtr, ID_1AD0);
        Addr1AD0Gad[1]   = GetDlgItem(MonitorWindowPtr, ID_1AD1);
        Addr1AD0Gad[2]   = GetDlgItem(MonitorWindowPtr, ID_1AD2);
        Addr1AD0Gad[3]   = GetDlgItem(MonitorWindowPtr, ID_1AD3);
        Addr1AD0Gad[4]   = GetDlgItem(MonitorWindowPtr, ID_1AD4);
        Addr1AD0Gad[5]   = GetDlgItem(MonitorWindowPtr, ID_1AD5);
        Addr1AD0Gad[6]   = GetDlgItem(MonitorWindowPtr, ID_1AD6);
        Addr1AD0Gad[7]   = GetDlgItem(MonitorWindowPtr, ID_1AD7);
        Addr1AD0Gad[8]   = GetDlgItem(MonitorWindowPtr, ID_1AD8);
        Addr1AD0Gad[9]   = GetDlgItem(MonitorWindowPtr, ID_1AD9);
        Addr1AD0Gad[10]  = GetDlgItem(MonitorWindowPtr, ID_1ADA);
        Addr1AD0Gad[11]  = GetDlgItem(MonitorWindowPtr, ID_1ADB);
        Addr1AD0Gad[12]  = GetDlgItem(MonitorWindowPtr, ID_1ADC);
        Addr1AD0Gad[13]  = GetDlgItem(MonitorWindowPtr, ID_1ADD);
        Addr1AD0Gad[14]  = GetDlgItem(MonitorWindowPtr, ID_1ADE);
        Addr1AD0Gad[15]  = GetDlgItem(MonitorWindowPtr, ID_1ADF);
        Addr1AD0Gad[16]  = GetDlgItem(MonitorWindowPtr, ID_1AE0);
        Addr1AD0Gad[17]  = GetDlgItem(MonitorWindowPtr, ID_1AE1);
        Addr1AD0Gad[18]  = GetDlgItem(MonitorWindowPtr, ID_1AE2);
        Addr1AD0Gad[19]  = GetDlgItem(MonitorWindowPtr, ID_1AE3);
        Addr1AD0Gad[20]  = GetDlgItem(MonitorWindowPtr, ID_1AE4);
        Addr1AD0Gad[21]  = GetDlgItem(MonitorWindowPtr, ID_1AE5);
        Addr1AD0Gad[22]  = GetDlgItem(MonitorWindowPtr, ID_1AE6);
        Addr1AD0Gad[23]  = GetDlgItem(MonitorWindowPtr, ID_1AE7);
        Addr1AD0Gad[24]  = GetDlgItem(MonitorWindowPtr, ID_1AE8);
        Addr1AD0Gad[25]  = GetDlgItem(MonitorWindowPtr, ID_1AE9);
        Addr1AD0Gad[26]  = GetDlgItem(MonitorWindowPtr, ID_1AEA);
        Addr1AD0Gad[27]  = GetDlgItem(MonitorWindowPtr, ID_1AEB);
        Addr1AD0Gad[28]  = GetDlgItem(MonitorWindowPtr, ID_1AEC);
        Addr1AD0Gad[29]  = GetDlgItem(MonitorWindowPtr, ID_1AED);
        Addr1AD0Gad[30]  = GetDlgItem(MonitorWindowPtr, ID_1AEE);
        Addr1AD0Gad[31]  = GetDlgItem(MonitorWindowPtr, ID_1AEF);
        Addr1AD0Gad[32]  = GetDlgItem(MonitorWindowPtr, ID_1AF0);
        Addr1AD0Gad[33]  = GetDlgItem(MonitorWindowPtr, ID_1AF1);
        Addr1AD0Gad[34]  = GetDlgItem(MonitorWindowPtr, ID_1AF2);
        Addr1AD0Gad[35]  = GetDlgItem(MonitorWindowPtr, ID_1AF3);
        Addr1AD0Gad[36]  = GetDlgItem(MonitorWindowPtr, ID_1AF4);
        Addr1AD0Gad[37]  = GetDlgItem(MonitorWindowPtr, ID_1AF5);
        Addr1AD0Gad[38]  = GetDlgItem(MonitorWindowPtr, ID_1AF6);
        Addr1AD0Gad[39]  = GetDlgItem(MonitorWindowPtr, ID_1AF7);
        Addr1AD0Gad[40]  = GetDlgItem(MonitorWindowPtr, ID_1AF8);
        Addr1AD0Gad[41]  = GetDlgItem(MonitorWindowPtr, ID_1AF9);
        Addr1AD0Gad[42]  = GetDlgItem(MonitorWindowPtr, ID_1AFA);
        Addr1AD0Gad[43]  = GetDlgItem(MonitorWindowPtr, ID_1AFB);
        Addr1AD0Gad[44]  = GetDlgItem(MonitorWindowPtr, ID_1AFC);
        Addr1AD0Gad[45]  = GetDlgItem(MonitorWindowPtr, ID_1AFD);
        Addr1AD0Gad[46]  = GetDlgItem(MonitorWindowPtr, ID_1AFE);
        Addr1AD0Gad[47]  = GetDlgItem(MonitorWindowPtr, ID_1AFF);
    } else
    {   // assert(machine == INTERTON || machine == ELEKTOR);

        // PVI chip...

        NOISEPtr         = GetDlgItem(MonitorWindowPtr, ID_NOISE);
        SPR01COLOURSPtr  = GetDlgItem(MonitorWindowPtr, ID_SPR01COLOURS);
        SPR23COLOURSPtr  = GetDlgItem(MonitorWindowPtr, ID_SPR23COLOURS);
        SIZESPtr         = GetDlgItem(MonitorWindowPtr, ID_SIZES);
        SCORECTRLPtr     = GetDlgItem(MonitorWindowPtr, ID_SCORECTRL);
        SCORELTPtr       = GetDlgItem(MonitorWindowPtr, ID_SCORELT);
        SCORERTPtr       = GetDlgItem(MonitorWindowPtr, ID_SCORERT);
        SPRITE0XY2Ptr    = GetDlgItem(MonitorWindowPtr, ID_SPRITE0XY2);
        SPRITE1XY2Ptr    = GetDlgItem(MonitorWindowPtr, ID_SPRITE1XY2);
        SPRITE2XY2Ptr    = GetDlgItem(MonitorWindowPtr, ID_SPRITE2XY2);
        SPRITE3XY2Ptr    = GetDlgItem(MonitorWindowPtr, ID_SPRITE3XY2);

        if (machine == INTERTON)
        {   // PVI RAM...

            Addr1F0EGad[0]   = GetDlgItem(MonitorWindowPtr, ID_1F0E);
            Addr1F0EGad[1]   = GetDlgItem(MonitorWindowPtr, ID_1F0F);
            Addr1F1EGad[0]   = GetDlgItem(MonitorWindowPtr, ID_1F1E);
            Addr1F1EGad[1]   = GetDlgItem(MonitorWindowPtr, ID_1F1F);
            Addr1F4EGad[0]   = GetDlgItem(MonitorWindowPtr, ID_1F4E);
            Addr1F4EGad[1]   = GetDlgItem(MonitorWindowPtr, ID_1F4F);
            Addr1F4EGad[2]   = GetDlgItem(MonitorWindowPtr, ID_1F50);
            Addr1F4EGad[3]   = GetDlgItem(MonitorWindowPtr, ID_1F51);
            Addr1F4EGad[4]   = GetDlgItem(MonitorWindowPtr, ID_1F52);
            Addr1F4EGad[5]   = GetDlgItem(MonitorWindowPtr, ID_1F53);
            Addr1F4EGad[6]   = GetDlgItem(MonitorWindowPtr, ID_1F54);
            Addr1F4EGad[7]   = GetDlgItem(MonitorWindowPtr, ID_1F55);
            Addr1F4EGad[8]   = GetDlgItem(MonitorWindowPtr, ID_1F56);
            Addr1F4EGad[9]   = GetDlgItem(MonitorWindowPtr, ID_1F57);
            Addr1F4EGad[10]  = GetDlgItem(MonitorWindowPtr, ID_1F58);
            Addr1F4EGad[11]  = GetDlgItem(MonitorWindowPtr, ID_1F59);
            Addr1F4EGad[12]  = GetDlgItem(MonitorWindowPtr, ID_1F5A);
            Addr1F4EGad[13]  = GetDlgItem(MonitorWindowPtr, ID_1F5B);
            Addr1F4EGad[14]  = GetDlgItem(MonitorWindowPtr, ID_1F5C);
            Addr1F4EGad[15]  = GetDlgItem(MonitorWindowPtr, ID_1F5D);
            Addr1F4EGad[16]  = GetDlgItem(MonitorWindowPtr, ID_1F5E);
            Addr1F4EGad[17]  = GetDlgItem(MonitorWindowPtr, ID_1F5F);
            Addr1F4EGad[18]  = GetDlgItem(MonitorWindowPtr, ID_1F60);
            Addr1F4EGad[19]  = GetDlgItem(MonitorWindowPtr, ID_1F61);
            Addr1F4EGad[20]  = GetDlgItem(MonitorWindowPtr, ID_1F62);
            Addr1F4EGad[21]  = GetDlgItem(MonitorWindowPtr, ID_1F63);
            Addr1F4EGad[22]  = GetDlgItem(MonitorWindowPtr, ID_1F64);
            Addr1F4EGad[23]  = GetDlgItem(MonitorWindowPtr, ID_1F65);
            Addr1F4EGad[24]  = GetDlgItem(MonitorWindowPtr, ID_1F66);
            Addr1F4EGad[25]  = GetDlgItem(MonitorWindowPtr, ID_1F67);
            Addr1F4EGad[26]  = GetDlgItem(MonitorWindowPtr, ID_1F68);
            Addr1F4EGad[27]  = GetDlgItem(MonitorWindowPtr, ID_1F69);
            Addr1F4EGad[28]  = GetDlgItem(MonitorWindowPtr, ID_1F6A);
            Addr1F4EGad[29]  = GetDlgItem(MonitorWindowPtr, ID_1F6B);
            Addr1F4EGad[30]  = GetDlgItem(MonitorWindowPtr, ID_1F6C);
            Addr1F4EGad[31]  = GetDlgItem(MonitorWindowPtr, ID_1F6D);
            Addr1FADGad      = GetDlgItem(MonitorWindowPtr, ID_1FAD);
        } else
        {   // PSG #1
            PITCHAGad[0]     = GetDlgItem(MonitorWindowPtr, ID_PITCHA1);
            PITCHBGad[0]     = GetDlgItem(MonitorWindowPtr, ID_PITCHB1);
            PITCHCGad[0]     = GetDlgItem(MonitorWindowPtr, ID_PITCHC1);
            PITCHDGad[0]     = GetDlgItem(MonitorWindowPtr, ID_PITCHD1);
            AMPLITUDEAGad[0] = GetDlgItem(MonitorWindowPtr, ID_AMPLITUDEA1);
            AMPLITUDEBGad[0] = GetDlgItem(MonitorWindowPtr, ID_AMPLITUDEB1);
            AMPLITUDECGad[0] = GetDlgItem(MonitorWindowPtr, ID_AMPLITUDEC1);
            ENABLEGad[0]     = GetDlgItem(MonitorWindowPtr, ID_ENABLE1);
            PERIODGad[0]     = GetDlgItem(MonitorWindowPtr, ID_PERIOD1);
            SHAPEGad[0]      = GetDlgItem(MonitorWindowPtr, ID_SHAPE1);
            PORTAGad[0]      = GetDlgItem(MonitorWindowPtr, ID_PORTA1);
            PORTBGad[0]      = GetDlgItem(MonitorWindowPtr, ID_PORTB1);

            // PSG #2
            PITCHAGad[1]     = GetDlgItem(MonitorWindowPtr, ID_PITCHA2);
            PITCHBGad[1]     = GetDlgItem(MonitorWindowPtr, ID_PITCHB2);
            PITCHCGad[1]     = GetDlgItem(MonitorWindowPtr, ID_PITCHC2);
            PITCHDGad[1]     = GetDlgItem(MonitorWindowPtr, ID_PITCHD2);
            AMPLITUDEAGad[1] = GetDlgItem(MonitorWindowPtr, ID_AMPLITUDEA2);
            AMPLITUDEBGad[1] = GetDlgItem(MonitorWindowPtr, ID_AMPLITUDEB2);
            AMPLITUDECGad[1] = GetDlgItem(MonitorWindowPtr, ID_AMPLITUDEC2);
            ENABLEGad[1]     = GetDlgItem(MonitorWindowPtr, ID_ENABLE2);
            PERIODGad[1]     = GetDlgItem(MonitorWindowPtr, ID_PERIOD2);
            SHAPEGad[1]      = GetDlgItem(MonitorWindowPtr, ID_SHAPE2);
            PORTAGad[1]      = GetDlgItem(MonitorWindowPtr, ID_PORTA2);
            PORTBGad[1]      = GetDlgItem(MonitorWindowPtr, ID_PORTB2);
    }   }

    for (i = 0; i < 7; i++)
    {   monitorr[i] = 0;
    }
    for (i = 0; i < 8; i++)
    {   monitorras[i] = 0;
    }
    for (i = 0; i < 32; i++)
    {   monitor18D0[i] = 0;
    }
    for (i = 0; i < 4; i++)
    {   monitor18F8[i] = 0;
    }
    for (i = 0; i < 48; i++)
    {   monitor1AD0[i] = 0;
    }
    monitorpsu           =
    monitorpsl           =
    // UVI/PVI chips...
    monitorCONSOLE       =
    monitorPITCH         =
    monitorVOLUME        =
    monitorRESOLUTION    =
    monitorBGCOLLIDE     =
    monitorBGCOLOUR      =
    monitorVSCROLL       =
    monitorCHARLINE      =
    monitorSPRITECOLLIDE =
    monitorSPRITES01CTRL =
    monitorSPRITES23CTRL =
    monitorSPRITE0X      =
    monitorSPRITE0Y      =
    monitorSPRITE1X      =
    monitorSPRITE1Y      =
    monitorSPRITE2X      =
    monitorSPRITE2Y      =
    monitorSPRITE3X      =
    monitorSPRITE3Y      =
    monitorP1PADDLE      =
    monitorP1LEFTKEYS    =
    monitorP1MIDDLEKEYS  =
    monitorP1RIGHTKEYS   =
    monitorP1PALLADIUM   =
    monitorP2PADDLE      =
    monitorP2LEFTKEYS    =
    monitorP2MIDDLEKEYS  =
    monitorP2RIGHTKEYS   =
    monitorP2PALLADIUM   =

    // PVI...
    monitorNOISE         =
    monitorSIZES         =
    monitorSCORECTRL     =
    monitorSCORELT       =
    monitorSCORERT       =
    monitorSPR01COLOURS  =
    monitorSPR23COLOURS  =
    monitorSPRITE0X2     =
    monitorSPRITE0Y2     =
    monitorSPRITE1X2     =
    monitorSPRITE1Y2     =
    monitorSPRITE2X2     =
    monitorSPRITE2Y2     =
    monitorSPRITE3X2     =
    monitorSPRITE3Y2     = 0;

    for (i = 0; i <= 1; i++)
    {   monitorPITCHA[i]     =
        monitorPITCHB[i]     =
        monitorPITCHC[i]     =
        monitorPERIOD[i]     = 0;

        monitorPITCHD[i]     =
        monitorAMPLITUDEA[i] =
        monitorAMPLITUDEB[i] =
        monitorAMPLITUDEC[i] =
        monitorENABLE[i]     =
        monitorSHAPE[i]      =
        monitorPORTA[i]      =
        monitorPORTB[i]      = 0;
    }

    monitoriar           = 0;
    monitorrast          = 0;
    monitorelapsed       =
    monitorframes        = 0;

    SetActiveWindow(MainWindowPtr);

    updatemonitor(); // important when paused
}

EXPORT void updatemonitor(void)
{   PERSIST TEXT  bytestring[2 + 1],
                  wordstring[4 + 1],
                  coordstring[5 + 1] = "--,--",
                  decimalstring[10 + 1];
    AUTO    int   i; // PERSIST would be faster
    PERSIST int   offset; // PERSISTent for speed
    PERSIST RECT  TheRect; // PERSISTent for speed
    AUTO    HDC   ControlsRastPtr;
    PERSIST UBYTE newkeys[KEYS]; // PERSISTent for speed

PERSIST RECT ae_keyrect[KEYS] = { // they go left, top, right, bottom
{ 172,  73, 186,  82 }, // START
{ 191,  73, 205,  82 }, // A
{ 210,  73, 224,  82 }, // B
{ 166, 115, 202, 124 }, // RESET

{  34,  96,  49, 105 }, // '1'
{  35, 109,  50, 118 }, // '4'
{  36, 122,  51, 131 }, // '7'
{  37, 135,  52, 144 }, // 'Cl'
{  56,  95,  71, 104 }, // '2'
{  57, 108,  72, 117 }, // '5'
{  58, 121,  73, 130 }, // '8'
{  59, 134,  74, 143 }, // '0'
{  77,  94,  92, 103 }, // '3'
{  78, 107,  93, 116 }, // '6'
{  79, 120,  94, 129 }, // '9'
{  80, 133,  95, 142 }, // 'En'

{ 270,  90, 285,  99 }, // '1'
{ 270, 102, 285, 111 }, // '4'
{ 270, 115, 285, 124 }, // '7'
{ 270, 127, 285, 136 }, // 'Cl'
{ 291,  90, 306,  99 }, // '2'
{ 291, 102, 306, 111 }, // '5'
{ 291, 115, 306, 124 }, // '8'
{ 291, 127, 306, 136 }, // '0'
{ 312,  90, 327,  99 }, // '3'
{ 312, 102, 327, 111 }, // '6'
{ 312, 115, 327, 124 }, // '9'
{ 312, 127, 327, 136 }, // 'En'

{  55,  30,  63,  38 }, // 'I'
{  39,  45,  47,  53 }, // 'J'
{  55,  62,  63,  70 }, // 'K'
{  71,  45,  80,  53 }, // 'L'

{ 293,  29, 301,  37 }, // up
{ 276,  44, 284,  52 }, // left
{ 293,  57, 301,  65 }, // down
{ 308,  44, 316,  52 }, // right

{  33,  83,  48,  92 }, // p1 '2'
{  76,  81,  91,  90 }, // p1 '2'

{ 270,  78, 285,  87 }, // p2 '2'
{ 312,  78, 327,  87 }  // p2 '2'
};

PERSIST RECT i_keyrect[KEYS] = { // they go left, top, right, bottom
{ 197, 172, 226, 200 }, // START
{ 164, 172, 193, 200 }, // A
{   0,   0,   0,   0 }, // B (impossible)
{   0,   0,   0,   0 }, // RESET (impossible)

{  21, 134,  36, 143 }, // '1'
{  21, 151,  36, 160 }, // '4'
{  21, 168,  36, 177 }, // '7'
{  21, 185,  36, 194 }, // 'Cl'
{  40, 134,  55, 143 }, // '2'
{  40, 151,  55, 160 }, // '5'
{  40, 168,  55, 177 }, // '8'
{  40, 185,  55, 194 }, // '0'
{  59, 134,  74, 143 }, // '3'
{  59, 151,  74, 160 }, // '6'
{  59, 168,  74, 177 }, // '9'
{  59, 185,  74, 194 }, // 'En'

{ 247, 134, 262, 143 }, // '1'
{ 247, 150, 262, 159 }, // '4'
{ 247, 167, 262, 176 }, // '7'
{ 247, 183, 262, 192 }, // 'Cl'
{ 266, 134, 281, 143 }, // '2'
{ 266, 150, 281, 159 }, // '5'
{ 266, 167, 281, 176 }, // '8'
{ 266, 183, 281, 192 }, // '0'
{ 285, 134, 300, 143 }, // '3'
{ 285, 150, 300, 159 }, // '6'
{ 285, 167, 300, 176 }, // '9'
{ 285, 183, 300, 192 }, // 'En'

{  47,  55,  56,  63 }, // 'I'
{  28,  71,  37,  79 }, // 'J'
{  47,  87,  56,  95 }, // 'K'
{  64,  72,  73,  80 }, // 'L'

{ 265,  56, 274,  64 }, // up
{ 248,  72, 257,  80 }, // left
{ 265,  88, 274,  96 }, // down
{ 283,  72, 292,  80 }, // right

{  21, 117,  36, 126 }, // p1 '2'
{  59, 117,  74, 126 }, // p1 '2'

{ 247, 117, 262, 126 }, // p2 '2'
{ 285, 117, 300, 126 }  // p2 '2'
};

    if (ControlsWindowPtr)
    {   ControlsRastPtr = GetDC(ControlsWindowPtr);
		if (machine == ARCADIA)
        {   newkeys[0]  = memory[A_CONSOLE]      & 0x01;
            newkeys[1]  = memory[A_CONSOLE]      & 0x02;
            newkeys[2]  = memory[A_CONSOLE]      & 0x04;
            newkeys[3]  = 0;
            newkeys[4]  = memory[A_P1LEFTKEYS]   & 0x08;
            newkeys[5]  = memory[A_P1LEFTKEYS]   & 0x04;
            newkeys[6]  = memory[A_P1LEFTKEYS]   & 0x02;
            newkeys[7]  = memory[A_P1LEFTKEYS]   & 0x01;
            newkeys[8]  =
            newkeys[36] =
            newkeys[37] = memory[A_P1MIDDLEKEYS] & 0x08;
            newkeys[9]  = memory[A_P1MIDDLEKEYS] & 0x04;
            newkeys[10] = memory[A_P1MIDDLEKEYS] & 0x02;
            newkeys[11] = memory[A_P1MIDDLEKEYS] & 0x01;
            newkeys[12] = memory[A_P1RIGHTKEYS]  & 0x08;
            newkeys[13] = memory[A_P1RIGHTKEYS]  & 0x04;
            newkeys[14] = memory[A_P1RIGHTKEYS]  & 0x02;
            newkeys[15] = memory[A_P1RIGHTKEYS]  & 0x01;
            newkeys[16] = memory[A_P2LEFTKEYS]   & 0x08;
            newkeys[17] = memory[A_P2LEFTKEYS]   & 0x04;
            newkeys[18] = memory[A_P2LEFTKEYS]   & 0x02;
            newkeys[19] = memory[A_P2LEFTKEYS]   & 0x01;
            newkeys[20] =
            newkeys[38] =
            newkeys[39] = memory[A_P2MIDDLEKEYS] & 0x08;
            newkeys[21] = memory[A_P2MIDDLEKEYS] & 0x04;
            newkeys[22] = memory[A_P2MIDDLEKEYS] & 0x02;
            newkeys[23] = memory[A_P2MIDDLEKEYS] & 0x01;
            newkeys[24] = memory[A_P2RIGHTKEYS]  & 0x08;
            newkeys[25] = memory[A_P2RIGHTKEYS]  & 0x04;
            newkeys[26] = memory[A_P2RIGHTKEYS]  & 0x02;
            newkeys[27] = memory[A_P2RIGHTKEYS]  & 0x01;
        } else
        {   // assert(machine == INTERTON || machine == ELEKTOR);
            newkeys[0]  = memory[I_CONSOLE]      & 0x40;
            newkeys[1]  = memory[I_CONSOLE]      & 0x80;
            newkeys[2]  = memory[I_CONSOLE]      & 0x20;
            newkeys[3]  = memory[I_CONSOLE]      & 0x10;
            newkeys[4]  = memory[I_P1LEFTKEYS]   & 0x80;
            newkeys[5]  = memory[I_P1LEFTKEYS]   & 0x40;
            newkeys[6]  = memory[I_P1LEFTKEYS]   & 0x20;
            newkeys[7]  = memory[I_P1LEFTKEYS]   & 0x10;
            newkeys[8]  =
            newkeys[36] =
            newkeys[37] = memory[I_P1MIDDLEKEYS] & 0x80;
            newkeys[9]  = memory[I_P1MIDDLEKEYS] & 0x40;
            newkeys[10] = memory[I_P1MIDDLEKEYS] & 0x20;
            newkeys[11] = memory[I_P1MIDDLEKEYS] & 0x10;
            newkeys[12] = memory[I_P1RIGHTKEYS]  & 0x80;
            newkeys[13] = memory[I_P1RIGHTKEYS]  & 0x40;
            newkeys[14] = memory[I_P1RIGHTKEYS]  & 0x20;
            newkeys[15] = memory[I_P1RIGHTKEYS]  & 0x10;
            newkeys[16] = memory[I_P2LEFTKEYS]   & 0x80;
            newkeys[17] = memory[I_P2LEFTKEYS]   & 0x40;
            newkeys[18] = memory[I_P2LEFTKEYS]   & 0x20;
            newkeys[19] = memory[I_P2LEFTKEYS]   & 0x10;
            newkeys[20] =
            newkeys[38] =
            newkeys[39] = memory[I_P2MIDDLEKEYS] & 0x80;
            newkeys[21] = memory[I_P2MIDDLEKEYS] & 0x40;
            newkeys[22] = memory[I_P2MIDDLEKEYS] & 0x20;
            newkeys[23] = memory[I_P2MIDDLEKEYS] & 0x10;
            newkeys[24] = memory[I_P2RIGHTKEYS]  & 0x80;
            newkeys[25] = memory[I_P2RIGHTKEYS]  & 0x40;
            newkeys[26] = memory[I_P2RIGHTKEYS]  & 0x20;
            newkeys[27] = memory[I_P2RIGHTKEYS]  & 0x10;
        }
		
        if (sx[0] < 32)
        {   newkeys[29] = 1;
            newkeys[31] = 0;
        } elif (sx[0] > 224)
        {   newkeys[29] = 0;
            newkeys[31] = 1;
        } else
        {   newkeys[29] =
            newkeys[31] = 0;
        }
        if (sx[1] < 32)
        {   newkeys[33] = 1;
            newkeys[35] = 0;
        } elif (sx[1] > 224)
        {   newkeys[33] = 0;
            newkeys[35] = 1;
        } else
        {   newkeys[33] =
            newkeys[35] = 0;
        }
        if (sy[0] < 32)
        {   newkeys[28] = 1;
            newkeys[30] = 0;
        } elif (sy[0] > 224)
        {   newkeys[28] = 0;
            newkeys[30] = 1;
        } else
        {   newkeys[28] =
            newkeys[30] = 0;
        }
        if (sy[1] < 32)
        {   newkeys[32] = 1;
            newkeys[34] = 0;
        } elif (sy[1] > 224)
        {   newkeys[32] = 0;
            newkeys[34] = 1;
        } else
        {   newkeys[32] =
            newkeys[34] = 0;
        }
        
        for (i = 0; i < KEYS; i++)
        {   if (newkeys[i] != oldkeys[i])
            {   if (machine == INTERTON)
                {   InvertRect(ControlsRastPtr, &i_keyrect[i]);
                } else
                {   // assert(machine == ARCADIA || machine == ELEKTOR);
                    InvertRect(ControlsRastPtr, &ae_keyrect[i]);
                }
                oldkeys[i] = newkeys[i];
        }   }
        ReleaseDC(ControlsWindowPtr, ControlsRastPtr);
    }

    if (!MonitorWindowPtr)
    {   return;
    }

    // CPU chip...

    for (i = 0; i < 6; i++)
    {   if (r[i] != monitorr[i])
        {   monitorr[i] = r[i];
            hex1(bytestring, monitorr[i]);
            DISCARD SetWindowText(RGad[i], bytestring);
    }   }

    if (psu != monitorpsu)
    {   if ((psu & PSU_S) != (monitorpsu & PSU_S))
        {   if (psu & PSU_S)
            {   DISCARD SetWindowText(SensePtr, "S");
            } else
            {   DISCARD SetWindowText(SensePtr, "s");
        }   }
        if ((psu & PSU_F) != (monitorpsu & PSU_F))
        {   if (psu & PSU_F)
            {   DISCARD SetWindowText(FlagPtr, "F");
            } else
            {   DISCARD SetWindowText(FlagPtr, "f");
        }   }
        if ((psu & PSU_II) != (monitorpsu & PSU_II))
        {   if (psu & PSU_II)
            {   DISCARD SetWindowText(InterruptPtr, "I");
            } else
            {   DISCARD SetWindowText(InterruptPtr, "i");
        }   }
        if ((psu & PSU_SP) != (monitorpsu & PSU_SP))
        {   stcul_d(decimalstring, psu & PSU_SP);
            DISCARD SetWindowText(SPPtr, decimalstring);
        }

        monitorpsu = psu;
    }

    if (psl != monitorpsl)
    {   if ((psl & PSL_CC) != (monitorpsl & PSL_CC))
        {   DISCARD SetWindowText(CCPtr, ccstring[(psl & 0xC0) >> 6]); // %11000000 -> %00000011
        }

        if ((psl & PSL_IDC) != (monitorpsl & PSL_IDC))
        {   if (psl & PSL_IDC)
            {   DISCARD SetWindowText(IDCPtr, "D");
            } else
            {   DISCARD SetWindowText(IDCPtr, "d");
        }   }

        if ((psl & PSL_RS) != (monitorpsl & PSL_RS))
        {   if (psl & PSL_RS)
            {   DISCARD SetWindowText(RSPtr, "R");
            } else
            {   DISCARD SetWindowText(RSPtr, "r");
        }   }

        if ((psl & PSL_WC) != (monitorpsl & PSL_WC))
        {   if (psl & PSL_WC)
            {   DISCARD SetWindowText(WCPtr, "W");
            } else
            {   DISCARD SetWindowText(WCPtr, "w");
        }   }

        if ((psl & PSL_OVF) != (monitorpsl & PSL_OVF))
        {   if (psl & PSL_OVF)
            {   DISCARD SetWindowText(OVFPtr, "O");
            } else
            {   DISCARD SetWindowText(OVFPtr, "o");
        }   }

        if ((psl & PSL_COM) != (monitorpsl & PSL_COM))
        {   if (psl & PSL_COM)
            {   DISCARD SetWindowText(COMPtr, "M");
            } else
            {   DISCARD SetWindowText(COMPtr, "m");
        }   }

        if ((psl & PSL_C) != (monitorpsl & PSL_C))
        {   if (psl & PSL_C)
            {   DISCARD SetWindowText(CPtr, "C");
            } else
            {   DISCARD SetWindowText(CPtr, "c");
        }   }

        monitorpsl = psl;
    }

    for (i = 0; i < 8; i++)
    {   if (ras[i] != monitorras[i])
        {   monitorras[i] = ras[i];
            hex2(wordstring, monitorras[i]);
            DISCARD SetWindowText(RASGad[i], wordstring);
    }   }

    if (page + iar != monitoriar)
    {   monitoriar = page + iar;
        hex2(wordstring, monitoriar);
        DISCARD SetWindowText(IARPtr, wordstring);
    }

    if (frames != monitorframes)
    {   monitorframes = frames;
        stcul_d(decimalstring, frames);
        DISCARD SetWindowText(FramePtr, decimalstring);

        calcrunningtime();
        DISCARD SetWindowText(TimePtr, timestring);
    }
    if (monitorelapsed != elapsed + cycles)
    {   monitorelapsed = elapsed + cycles;
        stcul_d(decimalstring, monitorelapsed);
        DISCARD SetWindowText(ClockPtr, decimalstring);
    }
    if (rast != monitorrast)
    {   monitorrast = rast;
        stcul_d(decimalstring, rast);
        DISCARD SetWindowText(RastPtr, decimalstring);
    }

    if (machine == ARCADIA)
    {   // UVI chip...

        if (memory[A_CONSOLE] != monitorCONSOLE)
        {   monitorCONSOLE = memory[A_CONSOLE];
            hex1(bytestring, monitorCONSOLE);
            DISCARD SetWindowText(CONSOLEPtr, bytestring);
        }
        if (memory[A_PITCH] != monitorPITCH)
        {   monitorPITCH = memory[A_PITCH];
            hex1(bytestring, monitorPITCH);
            DISCARD SetWindowText(PITCHPtr, bytestring);
        }
        if (memory[A_VOLUME] != monitorVOLUME)
        {   monitorVOLUME = memory[A_VOLUME];
            hex1(bytestring, monitorVOLUME);
            DISCARD SetWindowText(VOLUMEPtr, bytestring);
        }

        if (monitorRESOLUTION != memory[A_RESOLUTION])
        {   monitorRESOLUTION = memory[A_RESOLUTION];
            hex1(bytestring, monitorRESOLUTION);
            DISCARD SetWindowText(RESOLUTIONPtr, bytestring);
        }
        if (monitorBGCOLOUR != memory[A_BGCOLOUR])
        {   monitorBGCOLOUR = memory[A_BGCOLOUR];
            hex1(bytestring, monitorBGCOLOUR);
            DISCARD SetWindowText(BGCOLOURPtr, bytestring);
        }
        if (monitorVSCROLL != memory[A_VSCROLL])
        {   monitorVSCROLL = memory[A_VSCROLL];
            hex1(bytestring, monitorVSCROLL);
            DISCARD SetWindowText(VSCROLLPtr, bytestring);
        }
        if (monitorCHARLINE != memory[A_CHARLINE])
        {   monitorCHARLINE = memory[A_CHARLINE];
            hex1(bytestring, monitorCHARLINE);
            DISCARD SetWindowText(CHARLINEPtr, bytestring);
        }

        if (monitorBGCOLLIDE != memory[A_BGCOLLIDE])
        {   monitorBGCOLLIDE = memory[A_BGCOLLIDE];
            hex1(bytestring, monitorBGCOLLIDE);
            DISCARD SetWindowText(BGCOLLIDEPtr, bytestring);
        }
        if (monitorSPRITECOLLIDE != memory[A_SPRITECOLLIDE])
        {   monitorSPRITECOLLIDE = memory[A_SPRITECOLLIDE];
            hex1(bytestring, monitorSPRITECOLLIDE);
            DISCARD SetWindowText(SPRITECOLLIDEPtr, bytestring);
        }
        if (monitorSPRITES01CTRL != memory[A_SPRITES01CTRL])
        {   monitorSPRITES01CTRL = memory[A_SPRITES01CTRL];
            hex1(bytestring, monitorSPRITES01CTRL);
            DISCARD SetWindowText(SPRITES01CTRLPtr, bytestring);
        }
        if (monitorSPRITES23CTRL != memory[A_SPRITES23CTRL])
        {   monitorSPRITES23CTRL = memory[A_SPRITES23CTRL];
            hex1(bytestring, monitorSPRITES23CTRL);
            DISCARD SetWindowText(SPRITES23CTRLPtr, bytestring);
        }

        if
        (   monitorSPRITE0X != memory[A_SPRITE0X]
         || monitorSPRITE0Y != memory[A_SPRITE0Y]
        )
        {   monitorSPRITE0X = memory[A_SPRITE0X];
            monitorSPRITE0Y = memory[A_SPRITE0Y];
            hex1(coordstring, monitorSPRITE0X);
            coordstring[2] = ',';
            hex1(&coordstring[3], monitorSPRITE0Y);
            DISCARD SetWindowText(SPRITE0XYPtr, coordstring);
        }

        if
        (   monitorSPRITE1X != memory[A_SPRITE1X]
         || monitorSPRITE1Y != memory[A_SPRITE1Y]
        )
        {   monitorSPRITE1X = memory[A_SPRITE1X];
            monitorSPRITE1Y = memory[A_SPRITE1Y];
            hex1(coordstring, monitorSPRITE1X);
            coordstring[2] = ',';
            hex1(&coordstring[3], monitorSPRITE1Y);
            DISCARD SetWindowText(SPRITE1XYPtr, coordstring);
        }

        if
        (   monitorSPRITE2X != memory[A_SPRITE2X]
         || monitorSPRITE2Y != memory[A_SPRITE2Y]
        )
        {   monitorSPRITE2X = memory[A_SPRITE2X];
            monitorSPRITE2Y = memory[A_SPRITE2Y];
            hex1(coordstring, monitorSPRITE2X);
            coordstring[2] = ',';
            hex1(&coordstring[3], monitorSPRITE2Y);
            DISCARD SetWindowText(SPRITE2XYPtr, coordstring);
        }

        if
        (   monitorSPRITE3X != memory[A_SPRITE3X]
         || monitorSPRITE3Y != memory[A_SPRITE3Y]
        )
        {   monitorSPRITE3X = memory[A_SPRITE3X];
            monitorSPRITE3Y = memory[A_SPRITE3Y];
            hex1(coordstring, monitorSPRITE3X);
            coordstring[2] = ',';
            hex1(&coordstring[3], monitorSPRITE3Y);
            DISCARD SetWindowText(SPRITE3XYPtr, coordstring);
        }

        if (monitorP1PADDLE != memory[A_P1PADDLE])
        {   monitorP1PADDLE = memory[A_P1PADDLE];
            hex1(bytestring, monitorP1PADDLE);
            DISCARD SetWindowText(P1PADDLEPtr, bytestring);
        }

        if (monitorP1LEFTKEYS != memory[A_P1LEFTKEYS])
        {   monitorP1LEFTKEYS = memory[A_P1LEFTKEYS];
            hex1(bytestring, monitorP1LEFTKEYS);
            DISCARD SetWindowText(P1LEFTKEYSPtr, bytestring);
        }

        if (monitorP1MIDDLEKEYS != memory[A_P1MIDDLEKEYS])
        {   monitorP1MIDDLEKEYS = memory[A_P1MIDDLEKEYS];
            hex1(bytestring, monitorP1MIDDLEKEYS);
            DISCARD SetWindowText(P1MIDDLEKEYSPtr, bytestring);
        }

        if (monitorP1RIGHTKEYS != memory[A_P1RIGHTKEYS])
        {   monitorP1RIGHTKEYS = memory[A_P1RIGHTKEYS];
            hex1(bytestring, monitorP1RIGHTKEYS);
            DISCARD SetWindowText(P1RIGHTKEYSPtr, bytestring);
        }

        if (monitorP1PALLADIUM != memory[A_P1PALLADIUM])
        {   monitorP1PALLADIUM = memory[A_P1PALLADIUM];
            hex1(bytestring, monitorP1PALLADIUM);
            DISCARD SetWindowText(P1PALLADIUMPtr, bytestring);
        }

        if (monitorP2PADDLE != memory[A_P2PADDLE])
        {   monitorP2PADDLE = memory[A_P2PADDLE];
            hex1(bytestring, monitorP2PADDLE);
            DISCARD SetWindowText(P2PADDLEPtr, bytestring);
        }

        if (monitorP2LEFTKEYS != memory[A_P2LEFTKEYS])
        {   monitorP2LEFTKEYS = memory[A_P2LEFTKEYS];
            hex1(bytestring, monitorP2LEFTKEYS);
            DISCARD SetWindowText(P2LEFTKEYSPtr, bytestring);
        }

        if (monitorP2MIDDLEKEYS != memory[A_P2MIDDLEKEYS])
        {   monitorP2MIDDLEKEYS = memory[A_P2MIDDLEKEYS];
            hex1(bytestring, monitorP2MIDDLEKEYS);
            DISCARD SetWindowText(P2MIDDLEKEYSPtr, bytestring);
        }

        if (monitorP2RIGHTKEYS != memory[A_P2RIGHTKEYS])
        {   monitorP2RIGHTKEYS = memory[A_P2RIGHTKEYS];
            hex1(bytestring, monitorP2RIGHTKEYS);
            DISCARD SetWindowText(P2RIGHTKEYSPtr, bytestring);
        }

        if (monitorP2PALLADIUM != memory[A_P2PALLADIUM])
        {   monitorP2PALLADIUM = memory[A_P2PALLADIUM];
            hex1(bytestring, monitorP2PALLADIUM);
            DISCARD SetWindowText(P2PALLADIUMPtr, bytestring);
        }

        // RAM...

        for (i = 0; i < 32; i++)
        {   if (monitor18D0[i] != memory[0x18D0 + i])
            {   monitor18D0[i] = memory[0x18D0 + i];
                hex1(bytestring, monitor18D0[i]);
                DISCARD SetWindowText(Addr18D0Gad[i], bytestring);
        }   }
        for (i = 0; i < 4; i++)
        {   if (monitor18F8[i] != memory[0x18F8 + i])
            {   monitor18F8[i] = memory[0x18F8 + i];
                hex1(bytestring, monitor18F8[i]);
                DISCARD SetWindowText(Addr18F8Gad[i], bytestring);
        }   }
        for (i = 0; i < 48; i++)
        {   if (monitor1AD0[i] != memory[0x1AD0 + i])
            {   monitor1AD0[i] = memory[0x1AD0 + i];
                hex1(bytestring, monitor1AD0[i]);
                DISCARD SetWindowText(Addr1AD0Gad[i], bytestring);
    }   }   }
    else
    {   // assert(machine == INTERTON || machine == ELEKTOR);

        // PVI chip...

        if (memory[I_NOISE] != monitorNOISE)
        {   monitorNOISE = memory[I_NOISE];
            hex1(bytestring, monitorNOISE);
            DISCARD SetWindowText(NOISEPtr, bytestring);
        }
        if (memory[I_PITCH] != monitorPITCH)
        {   monitorPITCH = memory[I_PITCH];
            hex1(bytestring, monitorPITCH);
            DISCARD SetWindowText(PITCHPtr, bytestring);
        }
        if (memory[I_BGCOLOUR] != monitorBGCOLOUR)
        {   monitorBGCOLOUR = memory[I_BGCOLOUR];
            hex1(bytestring, monitorBGCOLOUR);
            DISCARD SetWindowText(BGCOLOURPtr, bytestring);
        }
        if (memory[I_SIZES] != monitorSIZES)
        {   monitorVOLUME = memory[I_SIZES];
            hex1(bytestring, monitorSIZES);
            DISCARD SetWindowText(SIZESPtr, bytestring);
        }

        if (frames != monitorframes)
        {   monitorframes = frames;
            stcul_d(decimalstring, frames);
            DISCARD SetWindowText(FramePtr, decimalstring);
        }

        if (monitorSCORECTRL != memory[I_SCORECTRL])
        {   monitorSCORECTRL = memory[I_SCORECTRL];
            hex1(bytestring, monitorSCORECTRL);
            DISCARD SetWindowText(SCORECTRLPtr, bytestring);
        }
        if (monitorSCORELT != memory[I_SCORELT])
        {   monitorSCORELT = memory[I_SCORELT];
            hex1(bytestring, monitorSCORELT);
            DISCARD SetWindowText(SCORELTPtr, bytestring);
        }
        if (monitorSCORERT != memory[I_SCORERT])
        {   monitorSCORERT = memory[I_SCORERT];
            hex1(bytestring, monitorSCORERT);
            DISCARD SetWindowText(SCORERTPtr, bytestring);
        }

        if (monitorBGCOLLIDE != memory[I_BGCOLLIDE])
        {   monitorBGCOLLIDE = memory[I_BGCOLLIDE];
            hex1(bytestring, monitorBGCOLLIDE);
            DISCARD SetWindowText(BGCOLLIDEPtr, bytestring);
        }
        if (monitorSPRITECOLLIDE != memory[I_SPRITECOLLIDE])
        {   monitorSPRITECOLLIDE = memory[I_SPRITECOLLIDE];
            hex1(bytestring, monitorSPRITECOLLIDE);
            DISCARD SetWindowText(SPRITECOLLIDEPtr, bytestring);
        }
        if (monitorSPRITES01CTRL != memory[I_SPR23COLOURS])
        {   monitorSPRITES01CTRL = memory[I_SPR23COLOURS];
            hex1(bytestring, monitorSPR01COLOURS);
            DISCARD SetWindowText(SPR01COLOURSPtr, bytestring);
        }
        if (monitorSPRITES23CTRL != memory[I_SPR23COLOURS])
        {   monitorSPRITES23CTRL = memory[I_SPR23COLOURS];
            hex1(bytestring, monitorSPR23COLOURS);
            DISCARD SetWindowText(SPR23COLOURSPtr, bytestring);
        }

        if
        (   monitorSPRITE0X != memory[I_SPRITE0AX]
         || monitorSPRITE0Y != memory[I_SPRITE0AY]
        )
        {   monitorSPRITE0X = memory[I_SPRITE0AX];
            monitorSPRITE0Y = memory[I_SPRITE0AY];
            hex1(coordstring, monitorSPRITE0X);
            coordstring[2] = ',';
            hex1(&coordstring[3], monitorSPRITE0Y);
            DISCARD SetWindowText(SPRITE0XYPtr, coordstring);
        }
        if
        (   monitorSPRITE1X != memory[I_SPRITE1AX]
         || monitorSPRITE1Y != memory[I_SPRITE1AY]
        )
        {   monitorSPRITE1X = memory[I_SPRITE1AX];
            monitorSPRITE1Y = memory[I_SPRITE1AY];
            hex1(coordstring, monitorSPRITE1X);
            coordstring[2] = ',';
            hex1(&coordstring[3], monitorSPRITE1Y);
            DISCARD SetWindowText(SPRITE1XYPtr, coordstring);
        }
        if
        (   monitorSPRITE2X != memory[I_SPRITE2AX]
         || monitorSPRITE2Y != memory[I_SPRITE2AY]
        )
        {   monitorSPRITE2X = memory[I_SPRITE2AX];
            monitorSPRITE2Y = memory[I_SPRITE2AY];
            hex1(coordstring, monitorSPRITE2X);
            coordstring[2] = ',';
            hex1(&coordstring[3], monitorSPRITE2Y);
            DISCARD SetWindowText(SPRITE2XYPtr, coordstring);
        }
        if
        (   monitorSPRITE3X != memory[I_SPRITE3AX]
         || monitorSPRITE3Y != memory[I_SPRITE3AY]
        )
        {   monitorSPRITE3X = memory[I_SPRITE3AX];
            monitorSPRITE3Y = memory[I_SPRITE3AY];
            hex1(coordstring, monitorSPRITE3X);
            coordstring[2] = ',';
            hex1(&coordstring[3], monitorSPRITE3Y);
            DISCARD SetWindowText(SPRITE3XYPtr, coordstring);
        }

        if
        (   monitorSPRITE0X2 != memory[I_SPRITE0BX]
         || monitorSPRITE0Y2 != memory[I_SPRITE0BY]
        )
        {   monitorSPRITE0X2 = memory[I_SPRITE0BX];
            monitorSPRITE0Y2 = memory[I_SPRITE0BY];
            hex1(coordstring, monitorSPRITE0X2);
            coordstring[2] = ',';
            hex1(&coordstring[3], monitorSPRITE0Y2);
            DISCARD SetWindowText(SPRITE0XY2Ptr, coordstring);
        }
        if
        (   monitorSPRITE1X2 != memory[I_SPRITE1BX]
         || monitorSPRITE1Y2 != memory[I_SPRITE1BY]
        )
        {   monitorSPRITE1X2 = memory[I_SPRITE1BX];
            monitorSPRITE1Y2 = memory[I_SPRITE1BY];
            hex1(coordstring, monitorSPRITE1X2);
            coordstring[2] = ',';
            hex1(&coordstring[3], monitorSPRITE1Y2);
            DISCARD SetWindowText(SPRITE1XY2Ptr, coordstring);
        }
        if
        (   monitorSPRITE2X2 != memory[I_SPRITE2BX]
         || monitorSPRITE2Y2 != memory[I_SPRITE2BY]
        )
        {   monitorSPRITE2X2 = memory[I_SPRITE2BX];
            monitorSPRITE2Y2 = memory[I_SPRITE2BY];
            hex1(coordstring, monitorSPRITE2X2);
            coordstring[2] = ',';
            hex1(&coordstring[3], monitorSPRITE2Y2);
            DISCARD SetWindowText(SPRITE2XY2Ptr, coordstring);
        }
        if
        (   monitorSPRITE3X2 != memory[I_SPRITE3BX]
         || monitorSPRITE3Y2 != memory[I_SPRITE3BY]
        )
        {   monitorSPRITE3X2 = memory[I_SPRITE3BX];
            monitorSPRITE3Y2 = memory[I_SPRITE3BY];
            hex1(coordstring, monitorSPRITE3X2);
            coordstring[2] = ',';
            hex1(&coordstring[3], monitorSPRITE3Y2);
            DISCARD SetWindowText(SPRITE3XY2Ptr, coordstring);
        }

        if (monitorCONSOLE != memory[I_CONSOLE])
        {   monitorCONSOLE = memory[I_CONSOLE];
            hex1(bytestring, monitorCONSOLE);
            DISCARD SetWindowText(CONSOLEPtr, bytestring);
        }
        if (monitorP1PADDLE != memory[I_P1PADDLE])
        {   monitorP1PADDLE = memory[I_P1PADDLE];
            hex1(bytestring, monitorP1PADDLE);
            DISCARD SetWindowText(P1PADDLEPtr, bytestring);
        }
        if (monitorP2PADDLE != memory[I_P2PADDLE])
        {   monitorP2PADDLE = memory[I_P2PADDLE];
            hex1(bytestring, monitorP2PADDLE);
            DISCARD SetWindowText(P2PADDLEPtr, bytestring);
        }
        if (monitorP1LEFTKEYS != memory[I_P1LEFTKEYS])
        {   monitorP1LEFTKEYS = memory[I_P1LEFTKEYS];
            hex1(bytestring, monitorP1LEFTKEYS);
            DISCARD SetWindowText(P1LEFTKEYSPtr, bytestring);
        }
        if (monitorP1MIDDLEKEYS != memory[I_P1MIDDLEKEYS])
        {   monitorP1MIDDLEKEYS = memory[I_P1MIDDLEKEYS];
            hex1(bytestring, monitorP1MIDDLEKEYS);
            DISCARD SetWindowText(P1MIDDLEKEYSPtr, bytestring);
        }
        if (monitorP1RIGHTKEYS != memory[I_P1RIGHTKEYS])
        {   monitorP1RIGHTKEYS = memory[I_P1RIGHTKEYS];
            hex1(bytestring, monitorP1RIGHTKEYS);
            DISCARD SetWindowText(P1RIGHTKEYSPtr, bytestring);
        }
        if (monitorP2LEFTKEYS != memory[I_P2LEFTKEYS])
        {   monitorP2LEFTKEYS = memory[I_P2LEFTKEYS];
            hex1(bytestring, monitorP2LEFTKEYS);
            DISCARD SetWindowText(P2LEFTKEYSPtr, bytestring);
        }
        if (monitorP2MIDDLEKEYS != memory[I_P2MIDDLEKEYS])
        {   monitorP2MIDDLEKEYS = memory[I_P2MIDDLEKEYS];
            hex1(bytestring, monitorP2MIDDLEKEYS);
            DISCARD SetWindowText(P2MIDDLEKEYSPtr, bytestring);
        }
        if (monitorP2RIGHTKEYS != memory[I_P2RIGHTKEYS])
        {   monitorP2RIGHTKEYS = memory[I_P2RIGHTKEYS];
            hex1(bytestring, monitorP2RIGHTKEYS);
            DISCARD SetWindowText(P2RIGHTKEYSPtr, bytestring);
        }

        if (machine == INTERTON)
        {   // RAM...

            for (i = 0; i < 2; i++) // $1F0E..$1F0F
            {   if (monitor1F0E[i] != memory[0x1F0E + i])
                {   monitor1F0E[i] = memory[0x1F0E + i];
                    hex1(bytestring, monitor1F0E[i]);
                    DISCARD SetWindowText(Addr1F0EGad[i], bytestring);
            }   }
            for (i = 0; i < 2; i++) // $1F1E..$1F1F
            {   if (monitor1F1E[i] != memory[0x1F1E + i])
                {   monitor1F1E[i] = memory[0x1F1E + i];
                    hex1(bytestring, monitor1F1E[i]);
                    DISCARD SetWindowText(Addr1F1EGad[i], bytestring);
            }   }
            for (i = 0; i < 32; i++) // $1F4E..1F6D
            {   if (monitor1F4E[i] != memory[0x1F4E + i])
                {   monitor1F4E[i] = memory[0x1F4E + i];
                    hex1(bytestring, monitor1F4E[i]);
                    DISCARD SetWindowText(Addr1F4EGad[i], bytestring);
            }   }
            if (monitor1FAD != memory[0x1FAD]) // $1FAD
            {   monitor1FAD = memory[0x1FAD];
                hex1(bytestring, monitor1FAD);
                DISCARD SetWindowText(Addr1FADGad, bytestring);
        }   }
        else
        {   // assert(machine == ELEKTOR);

            for (i = 0; i <= 1; i++)
            {   offset = i * 16;

                if (monitorPITCHA[i] != ((memory[E_PITCHA1_H + offset] * 256) + memory[E_PITCHA1_L + offset]))
                {   monitorPITCHA[i] = (memory[E_PITCHA1_H + offset] * 256) + memory[E_PITCHA1_L + offset];
                    hex2(bytestring, monitorPITCHA[i]);
                    DISCARD SetWindowText(PITCHAGad[i], bytestring);
                }
                if (monitorPITCHB[i] != ((memory[E_PITCHB1_H + offset] * 256) + memory[E_PITCHB1_L + offset]))
                {   monitorPITCHB[i] = (memory[E_PITCHB1_H + offset] * 256) + memory[E_PITCHB1_L + offset];
                    hex2(bytestring, monitorPITCHB[i]);
                    DISCARD SetWindowText(PITCHBGad[i], bytestring);
                }
                if (monitorPITCHC[i] != ((memory[E_PITCHC1_H + offset] * 256) + memory[E_PITCHC1_L + offset]))
                {   monitorPITCHC[i] = (memory[E_PITCHC1_H + offset] * 256) + memory[E_PITCHC1_L + offset];
                    hex2(bytestring, monitorPITCHC[i]);
                    DISCARD SetWindowText(PITCHCGad[i], bytestring);
                }
                if (monitorPITCHD[i] != memory[E_PITCHD1 + offset])
                {   monitorPITCHD[i] = memory[E_PITCHD1 + offset];
                    hex1(bytestring, monitorPITCHD[i]);
                    DISCARD SetWindowText(PITCHDGad[i], bytestring);
                }
                if (monitorENABLE[i] != memory[E_ENABLE1 + offset])
                {   monitorENABLE[i] = memory[E_ENABLE1 + offset];
                    hex1(bytestring, monitorENABLE[i]);
                    DISCARD SetWindowText(ENABLEGad[i], bytestring);
                }
                if (monitorAMPLITUDEA[i] != memory[E_AMPLITUDEA1 + offset])
                {   monitorAMPLITUDEA[i] = memory[E_AMPLITUDEA1 + offset];
                    hex1(bytestring, monitorAMPLITUDEA[i]);
                    DISCARD SetWindowText(AMPLITUDEAGad[i], bytestring);
                }
                if (monitorAMPLITUDEB[i] != memory[E_AMPLITUDEB1 + offset])
                {   monitorAMPLITUDEB[i] = memory[E_AMPLITUDEB1 + offset];
                    hex1(bytestring, monitorAMPLITUDEB[i]);
                    DISCARD SetWindowText(AMPLITUDEBGad[i], bytestring);
                }
                if (monitorAMPLITUDEC[i] != memory[E_AMPLITUDEC1 + offset])
                {   monitorAMPLITUDEC[i] = memory[E_AMPLITUDEC1 + offset];
                    hex1(bytestring, monitorAMPLITUDEC[i]);
                    DISCARD SetWindowText(AMPLITUDECGad[i], bytestring);
                }
                if (monitorPERIOD[i] != ((memory[E_PERIOD1_H + offset] * 256) + memory[E_PERIOD1_L + offset]))
                {   monitorPERIOD[i] = (memory[E_PERIOD1_H + offset] * 256) + memory[E_PERIOD1_L + offset];
                    hex2(bytestring, monitorPERIOD[i]);
                    DISCARD SetWindowText(PERIODGad[i], bytestring);
                }
                if (monitorSHAPE[i] != memory[E_SHAPE1 + offset])
                {   monitorSHAPE[i] = memory[E_SHAPE1 + offset];
                    hex1(bytestring, monitorSHAPE[i]);
                    DISCARD SetWindowText(SHAPEGad[i], bytestring);
                }
                if (monitorPORTA[i] != memory[E_PORTA1 + offset])
                {   monitorPORTA[i] = memory[E_PORTA1 + offset];
                    hex1(bytestring, monitorPORTA[i]);
                    DISCARD SetWindowText(PORTAGad[i], bytestring);
                }
                if (monitorPORTB[i] != memory[E_PORTB1 + offset])
                {   monitorPORTB[i] = memory[E_PORTB1 + offset];
                    hex1(bytestring, monitorPORTB[i]);
                    DISCARD SetWindowText(PORTBGad[i], bytestring);
}   }   }   }   }

EXPORT void closemonitor(void)
{   if (MonitorWindowPtr && monitortype != machine)
    {   DestroyWindow(MonitorWindowPtr);
        MonitorWindowPtr = NULL;
        updatemenu(MENUITEM_MONITOR);
        // perhaps reopen it?
    }
    if
    (   ControlsWindowPtr
     && controlstype != machine
    )
    {   DestroyWindow(ControlsWindowPtr);
        ControlsWindowPtr = NULL;
        updatemenu(MENUITEM_CONTROLS);
        // perhaps reopen it?
}   }
